### robust and resistent regression

phones.lm <- lm(calls ~ year, data = phones)
phones.rlm <- rlm(calls ~ year, phones, maxit=50)
phones.lqs <- lqs(calls ~ year, phones)

with(phones, plot(year, calls))
abline(coef(phones.lm), col = "red")
abline(coef(phones.rlm), col = "blue")
abline(coef(phones.lqs), col = "green")

legend(52.5, 200,
	col = c("red", "blue", "green"),
	lwd = 2, bty = "n", legend =
	c("least squares", "M-estimate", "LTS"))

# ---


with(animals, {
	plot(log(Body), log(Brain))
# _	identify(log(Body), log(Brain), Name,
# _		col = "red", cex = 0.75)
})

require(robust)
BB.lm <- lm(log(Brain) ~ log(Body), animals)
BB.lmRob <- lmRob(log(Brain) ~ log(Body), animals)
BB.lqs <- lqs(log(Brain) ~ log(Body), animals)
abline(coef(BB.lm), col = "red")
abline(coef(BB.lmRob), col = "blue")
abline(coef(BB.lqs), col = "green")

legend(-5, 8,
  c("Least squares", "lmRob defaults", "lqs, method 'lts'"),
	col = c("red", "blue", "green"),lwd = 2, bty = "n")

wt <- format(round(BB.lmRob$M.weights, 2))
uwt <- unique(sort(wt))
wt <- match(wt, uwt)
cx <- 2 - wt/max(wt)

with(animals,	plot(log(Body), log(Brain), col = wt, cex = cx))
abline(BB.lmRob, col = "gold")
legend(-5, 8, uwt, pch=1, col = 1:length(uwt))

# --- the morphometric example

xyplot(log(Weight) ~ log(Length) | Species*Sex, LWData)

LWData <- transform(LWData,
	SS = factor(paste(substring(Species, 1, 5),
			      substring(Sex,     1, 1), sep="-")))
require(nlme)
prawns.lm1 <- lmList(log(Weight) ~ log(Length) | SS, LWData,
                            pool = FALSE)
round(summary(prawns.lm1)$coef, 4)

prawns.lm2 <- lm(log(Weight) ~ SS/log(Length) - 1, LWData)
round(summary(prawns.lm2)$coef, 4)


prawns.lmR <- lmRob(log(Weight) ~ SS/log(Length) - 1, LWData)
round(summary(prawns.lmR, cor = F)$coef, 4)

# test for bias

test.lmRob(prawns.lmR)

wt <- prawns.lmR$M.weights
wtf <- factor(ifelse(wt == 0, 0, ifelse(wt < 1, 0.5, 1)))
table(wtf)

# final display

palette("default")
xyplot(abs(resid(prawns.lmR))^0.25 ~ fitted(prawns.lmR) | Sex*Species,
	LWData, groups = wtf, as.table = T,  col = 2:4,
	key = list(columns = 3, background = 0, points = list(pch = 1, col = 2:4),
	text = list(c("Zero", "Intermediate", "Full"), col = 2:4)))

xyplot(log(Weight) ~ log(Length) | Sex*Species, LWData, groups = wtf,
  pch = ".", col = 2:4, cex = 1.5, auto.key = TRUE)

# robust t alternative

prawns.tRob <- tRob(log(Weight) ~ SS/log(Length) - 1, LWData)
summary(prawns.tRob)

cbind(Least_sq = coef(prawns.lm2),
      Robust = coef(prawns.lmR),
      T_robust = coef(prawns.tRob))
